import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ReactTable from "react-table";
import Loading from "../../../../core/Loading";
import './DocumentsList.css';
import Ionicon from 'react-ionicons'
import {NavLink} from "react-router-dom";
import moment from 'moment';
import 'moment/locale/it';
import gql from 'graphql-tag';
import {graphql, compose, withApollo} from "react-apollo";

import DocumentiFilters from "./components/DocumentiFilters";

import Permissions from '../../../../permissions'
import DeleteButton from "../../../../core/DeleteButton";

class DocumentsListC extends Component {

  constructor(props) {
    super(props);

    this.state = {
      filter: '',
      paginationLimit: 50,
      paginationOffset: 1,
      columns: [
        {
          Header: "Scarica",
          filterable: false,
          sortable: false,
          width: 200,
	  style: {'text-align':'center'},
	  Cell:  (row) => (<div><a target='_blank' href={'/LifeEremitaWeb/download/'+row.original.uuid}><img style={{'maxHeight':(row.original.formato=='PDF'?50:120),'margin':'2px'}} src={'/LifeEremitaWeb/thumbnail/'+row.original.uuid} /></a>
		  
		  </div>),
        },
	{
          Header: "Nome",
          accessor: "nomeFile",
          filterable: false,
          sortable: false,
	  style: {'text-align':'center','vertical-align':'middle','whiteSpace':'normal'},
	  Cell:  (row) => (<span style={{'position':'relative','top':'50%','transform':'translateY(-50%)'}}>{row.value}</span>),
        },
        {
          Header: "Descrizione",
          accessor: "descrizione",
          filterable: false,
          sortable: false,
	  style: {'text-align':'center','vertical-align':'middle','whiteSpace':'normal'},
	  Cell: (row) => (<span style={{'position':'relative','top':'50%','transform':'translateY(-50%)'}}>{row.value}</span>),

        },
        {
          Header: "Caricato in",
          filterable: false,
          sortable: false,
	  style: {'text-align':'center','vertical-align':'middle','whiteSpace':'normal'},
	  Cell: (row) => {
		  if (!row.original.entita) return <span style={{'position':'relative','top':'50%','transform':'translateY(-50%)'}}>Elenco documentale</span>
		  if (row.original.entita=='monitoraggio_specie') return <span style={{'position':'relative','top':'50%','transform':'translateY(-50%)'}}>Monitoraggio specie n. {row.original.idEntita}</span>
                  if (row.original.entita=='monitoraggio_habitat') return <span style={{'position':'relative','top':'50%','transform':'translateY(-50%)'}}>Monitoraggio habitat n. {row.original.idEntita}</span>
                  if (row.original.entita=='eremita_intervento') return <span style={{'position':'relative','top':'50%','transform':'translateY(-50%)'}}>Intervento n. {row.original.idEntita}</span>
			 return <span/>
	  },

        },

	        {
          Header: "Azioni",
          filterable: false,
          sortable: false,
          width: 120,
	  style: {'text-align':'center'},
	  Cell:  (row) => (<div style={{'position':'relative','top':'50%','transform':'translateY(-50%)'}}>
		  {this.props.utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.writeDocumento).length>0 &&
		  <div style={{display: 'flex', alignItems: 'center'}}>
		   <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
		  <NavLink className="btn ionicon-btn btn-light" to={props.match.url + "/" + row.original.id + "/edit"}>
                  <Ionicon icon="ios-create-outline"/>
              </NavLink>
		{!row.original.entita &&
		 <DeleteButton id={"delete-" + row.original.id} size={"sm"} onDelete={() => this.onDeleteItem(row.original.id)}>
                  <Ionicon icon="ios-trash-outline" color="#ffffff" />
                </DeleteButton>
		}
		  </div>
		  </div>
		  }
		  </div>),
        },

      ]
    };

    this.onFetchData = this.onFetchData.bind(this);
    this.onFilterChange = this.onFilterChange.bind(this);
    this.getTotalPages = this.getTotalPages.bind(this);
    this.onDeleteItem = this.onDeleteItem.bind(this);
  }

  componentWillMount() {
    moment.locale("it")
  }

  async onDeleteItem(id) {
	const { client } = this.props
	const result = await client.mutate({
      mutation: gql`mutation x($id: Long) {
          deleteDocumento(id: $id)
      }`,
      variables: {
        id: id
      }
    })
    this.props.data.refetch()
	}

  onFetchData(state, instance) {
    this.props.data.refetch({
      pagination: {
        limit: state.pageSize,
        offset: state.page * state.pageSize,
      },
      filtri: this.state.filters,
      //sort: sortObj,
    })
    this.setState({
      paginationLimit: state.pageSize,
      paginationOffset: state.page * state.pageSize
    })
  }

  onFilterChange(filter) {
    this.setState({filter: filter})

    this.props.data.refetch({
      pagination: {
        limit: this.state.paginationLimit,
        offset: this.state.paginationOffset
      },
      filtri: filter,
      //sort: sortObj,
    })
  }

  getTotalPages () {
    if (this.props.data.countDocumentos2 > 0) {
      return Math.ceil(this.props.data.countDocumentos2 / this.state.paginationLimit)
    }

    return 0
  }

  render() {
    const {
      data,
      match,
      utenteSessione
    } = this.props

   

    const {
      columns,
      pages,
    } = this.state

    if(data.error) {
      return(<div className="text-danger">
        Errore nella ricezione dei dati
      </div>)
    }

    /*if(data.loading) {
        return <Loading/>;
    }*/

        if(!utenteSessione || !utenteSessione.utenteSessione || utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.adminUsers).length==0) {
      return(<div className="text-danger">
        
      </div>)
    }

    

    return(
      
      <div className="container-fluid">
        <div className="btn-toolbar" style={{backgroundColor: '#fff'}}>
          <div className="btn-group mr-2 ml-auto">
	    {utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.insertDocumento).length>0 &&
            <NavLink className="btn ionicon-btn btn-light" to={match.url + "/create"}>
                <Ionicon icon="ios-add" style={{marginRight: '5px', marginLeft: '-8px'}}/>
                Nuovo documento
            </NavLink>
	    }
           
          </div>
        </div>

	    <DocumentiFilters
          onFilterChange={this.onFilterChange} />

        <ReactTable
          manual
          filterable
          loading={data.loading}
          noDataText={"Nessun documento presente"}
          onFetchData={this.onFetchData}
          pages={this.getTotalPages()}
          className="-highlight"
          data={data.documentos2}
          style={{}}
          defaultPageSize={50}
	  minRows={3}
          nextText="Avanti"
          previousText="Indietro"
          loadingText="Caricamento in corso..."
          rowsText="elementi"
          ofText="di"
          pageText="Pagina"
          columns={columns} />
      </div>
    )
  }
}

const DocumentsList = withApollo(DocumentsListC);
export default DocumentsList;

DocumentsList.defaultProps = {}

DocumentsList.propTypes = {

}
